<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFormatFieldToNewsType extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $bridge = new BridgeContentType();

        $this->migrateContent('formats');
        $bridge->contentTypeCreateOrUpdateField(
            'news',
            'formats',
            [
                'name' => 'formats',
                'searchable' => false,
                'translatable' => false,
                'default' => null,
                'search_result_field' => false,
                'required' => false,
                'weight' => 6,
                'title' => [
                    'fr' => 'Format'
                ],
                'description' => [
                    'fr' => '',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 6
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['formats'],
                    'cardinality' => 1,
                ],
            ],
            6
        );
    }
}
