<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateContentTypes extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $bridge = new BridgeContentType();

        $this->migrateContent('custom');
        $this->migrateContent('simple_pages');
        $this->migrateContent('folders');
        $this->migrateContent('documents');
        $this->migrateContent('tools');
        $this->migrateContent('events_categories');
        $this->migrateContent('events');
        $this->migrateContent('news_categories');
        $this->migrateContent('news');
        $this->migrateContent('users');

        $bridge->contentTypeDeleteField('user', 'user', 'shortcuts_menus');

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
