<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'page_catalogs',
        'translatable' => true,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => true,
        'title' => [
            'fr' => 'Pages catalogue'
        ],
    ],
    'fields' => [
        [
            'name' => 'banner',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => -3,
            'title' => [
                'fr' => 'Bannière'
            ],
            'description' => [
                'fr' => ''
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => -3,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'introduction',
            'searchable' => false,
            'translatable' => true,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => -4,
            'title' => [
                'fr' => 'Introduction'
            ],
            'description' => [
                'fr' => '',
                'en' => null,
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => -4,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'targets',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'filter_widget'       => 'checkboxesgroup',
            'filter_order'        => 1,
            'filter_category'     => '',
            'required' => true,
            'title' => [
                'fr' => 'Quelle est la cible ?',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'target_type' => 'targets',
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'staff_sizes',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'filter_widget'       => 'checkboxesgroup',
            'filter_order'        => 1,
            'filter_category'     => '',
            'required' => true,
            'title' => [
                'fr' => 'Ma taille d\'effectifs',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'target_type' => 'staff_sizes',
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'branches',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'filter_widget'       => 'checkboxesgroup',
            'filter_order'        => 1,
            'filter_category'     => '',
            'required' => true,
            'title' => [
                'fr' => 'Branche(s)',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'target_type' => 'branches',
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'regions',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'filter_widget'       => 'checkboxesgroup',
            'filter_order'        => 1,
            'filter_category'     => '',
            'required' => true,
            'title' => [
                'fr' => 'Région(s) ciblée(s)',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'target_type' => 'regions',
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'offer_themes',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'filter_widget'       => 'checkboxesgroup',
            'filter_order'        => 1,
            'filter_category'     => '',
            'required' => true,
            'title' => [
                'fr' => 'Thématique(s)',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'target_type' => 'offer_themes',
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'offer_structures',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'filter_widget'       => 'checkboxesgroup',
            'filter_order'        => 1,
            'filter_category'     => '',
            'required' => true,
            'title' => [
                'fr' => 'Structure de l\'offre',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'target_type' => 'offer_structures',
                'cardinality' => -1,
            ],
        ]
    ],
];
