<?php

return [
    'types'  => [
        'news'      => [
            'category' => 'news_categories',
            'comments' => true,
            'likes'    => true,
        ],
        'documents' => [
            'category' => 'folders',
            'comments' => false,
            'likes'    => true,
        ],
        'events'    => [
            'category' => 'events_categories',
            'comments' => true,
            'likes'    => true,
        ],
        'folders'    => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'learn_more'    => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'forms'    => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'dms_link'    => [
            'category' => 'folders',
            'comments' => false,
            'likes'    => false,
        ],
        'service_offers'    => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'tools'    => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'pages'    => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'custom'    => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'quiz'    => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'regions'    => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'emailings'    => [
            'category' => null,
            'comments' => true,
            'likes'    => true,
        ],
    ],
    'export' => [
        'contents'       => [
            'headers'    => [
                'uuid'         => 'UUID',
                'content_type' => 'Content type',
                'title'        => 'Title',
                'edit'         => 'Edit link',
            ],
            'presenters' => [
                'edit' => function ($value, $model) {
                    return env('APP_URL') . '/edit/' . class_to_type($model) . '/' . $model->uuid;
                },
            ],
        ],
        'users'          => [
            'headers' => [
                'email'     => 'Mail address',
                'full_name' => 'Full name',
            ],
        ],
        'authentication' => [
            'headers' => [],
        ],
    ],
];
