<?php

use Illuminate\Support\Str;
use Inside\Host\Bridge\BridgeContent;

if (!function_exists('get_entity')) {
    function get_entity(array $record, BridgeContent $bridge, string $bundle, string $column): ?array
    {
        $name = trim(ucwords(strtolower($record[$column])));

        if (empty($name)) {
            return null;
        }

        $query = call_user_func(type_to_class($bundle) . '::query');

        $entity = $query->where('title', $name)->first();

        if ($entity) {
            return [$entity->uuid];
        }

        $uuidBridge = $bridge->contentInsert($bundle, [
            'title' => $name,
            'type' => 'node',
            'bundle' => $bundle,
        ]);

        if ($uuidBridge) {
            return [$uuidBridge];
        }

        return null;
    }
}

return [
  'files' => [
      'opco' => [
          'path'      => env("OPCO_USERS_PATH", __DIR__ . '/../../../../imports/import.csv'),
          'separator' => ';',
          'fields' => [
              'name'        => function ($record, BridgeContent $bridge) {
                  return trim($record['samaccountname']);
              },
              'mail'        => function ($record, BridgeContent $bridge) {
                  return trim($record['mail']);
              },
              'firstname'   => function ($record, BridgeContent $bridge) {
                  return ucwords($record['prenom']);
              },
              'lastname'    => function ($record, BridgeContent $bridge) {
                  return ucwords($record['nom']);
              },
              'status' => function ($record, BridgeContent $bridge) {
                  return trim(Str::lower($record['etat'])) === "actif";
              }
          ]
      ]
  ]
];
