import TabsSpaceListingPage from '../pages/spaces/TabsSpaceListingPage'
import TabsSpacePage from '../pages/spaces/TabsSpacePage'
import { fetchTabsSpacePage, fetchTabsSpaceListingPage } from '../fetch/spaces'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: {
      component: 'minimal'
    }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'EventSubscriptionPage',
    meta: { disabled: false }
  },
  {
    name: 'LabsListingPage',
    path: '/labs',
    component: () => import('../pages/labs/LabsListingPage')
  },
  {
    name: 'ProductsListingPage',
    path: '/produits',
    component: () => import('../pages/products/ProductsListingPage')
  },
  {
    name: 'GedPage',
    props: {
      cardOverlayEnabled: false,
      extraFilters: {
        sort: ['weight:asc', 'title:asc']
      }
    },
    meta: { disabled: false }
  },
  {
    name: 'TabsSpaceListingPage',
    path: '/espaces/:category',
    component: withFetch(TabsSpaceListingPage, { size: 'xxl' })(
      fetchTabsSpaceListingPage
    )
  },
  {
    name: 'TabsSpacePage',
    path: '/espaces/:category/:slug',
    component: withFetch(TabsSpacePage, { size: 'xxl' })(fetchTabsSpacePage),
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    },
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  }
]
