import { http } from '@inside-library/helpers/Http'

const getTabsSpaces = async ({ data, uuid }) => {
  try {
    const { data: category } = await http.get('content/tabs_spaces', {
      fields: [{ tabs_spaces_categories: ['uuid', 'slug'] }],
      filters: { 'uuid:eq': uuid || data.uuid }
    })

    return {
      name: data.length !== 0 ? 'TabsSpacePage' : 'TabsSpaceListingPage',
      params: {
        category: category[0].tabs_spaces_categories.slug[0],
        slug: data.length !== 0 ? data.slug[0] : null
      }
    }
  } catch (err) {
    return { path: '/' }
  }
}

const getTabs = async ({ data, uuid }) => {
  try {
    const { data: category } = await http.get('content/tabs', {
      fields: [{ tabs_spaces: ['slug', { tabs_spaces_categories: ['slug'] }] }],
      filters: { 'uuid:eq': uuid || data.uuid }
    })

    return {
      name: 'TabsSpacePage',
      params: {
        category: category[0].tabs_spaces.tabs_spaces_categories.slug[0],
        slug: category[0].tabs_spaces.slug[0]
      }
    }
  } catch (err) {
    return { path: '/' }
  }
}

const getTabsPages = async ({ data, uuid }) => {
  try {
    const { data: category } = await http.get('content/tabs_pages', {
      fields: [
        {
          tabs: {
            tabs_spaces: ['slug', { tabs_spaces_categories: ['slug'] }]
          }
        }
      ],
      filters: { 'uuid:eq': uuid || data.uuid }
    })

    return {
      name: 'TabsSpacePage',
      params: {
        category: category[0].tabs.tabs_spaces.tabs_spaces_categories.slug[0],
        slug: category[0].tabs.tabs_spaces.slug[0]
      },
      query: { page: uuid || data.uuid }
    }
  } catch (err) {
    return { path: '/' }
  }
}

export default {
  labsCategories: {
    add: () => {
      return {
        name: 'LabsListingPage'
      }
    },
    delete: () => {
      return {
        name: 'LabsListingPage'
      }
    }
  },
  labs: {
    add: () => {
      return {
        name: 'LabsListingPage'
      }
    },
    delete: () => {
      return {
        name: 'LabsListingPage'
      }
    },
    globalSearch: ({ vm, data }) => ({
      action: () =>
        vm.triggerModal(
          'lab',
          'fetch',
          { item: data, content: data.content_type },
          { layout: 'right', transition: 'fadeInLeft' }
        )
    })
  },
  productsCategories: {
    add: () => {
      return {
        name: 'ProductsListingPage'
      }
    },
    delete: () => {
      return {
        name: 'ProductsListingPage'
      }
    }
  },
  productsStatuses: {
    add: () => {
      return {
        name: 'ProductsListingPage'
      }
    },
    delete: () => {
      return {
        name: 'ProductsListingPage'
      }
    }
  },
  productsInformations: {
    add: () => {
      return {
        name: 'ProductsListingPage'
      }
    },
    delete: () => {
      return {
        name: 'ProductsListingPage'
      }
    },
    globalSearch: ({ vm, data }) => ({
      action: () =>
        vm.triggerModal(
          'product',
          'fetch',
          { item: data, content: data.content_type },
          { layout: 'right', transition: 'fadeInLeft' }
        )
    })
  },
  tabsSpacesCategories: {
    add: async ({ data }) => {
      return {
        name: 'TabsSpaceListingPage',
        params: {
          category: data.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      return {
        route: {
          name: 'TabsSpaceListingPage',
          params: {
            category: data.slug[0]
          }
        }
      }
    }
  },
  tabsSpaces: {
    add: getTabsSpaces,
    delete: getTabsSpaces,
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  tabs: {
    add: getTabs,
    delete: getTabs,
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  tabsPages: {
    add: getTabsPages,
    delete: getTabsPages,
    globalSearch: () => ({
      routeAs: 'add'
    })
  }
}
