import { http } from '@inside-library/helpers/Http'

export const fetchTabsSpaceListingPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/tabs_spaces_categories', {
      fields: ['uuid', 'title', 'admin', 'content_type'],
      filters: { 'slug:eq': $route.params.category, 'status:eq': 1 }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchTabsSpacePage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/tabs_spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'color',
        'introduction',
        'admin',
        'content_type'
      ],
      filters: { 'slug:eq': $route.params.slug, 'status:eq': 1 }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
