export default {
  globals: {
    inputs: {
      date: {
        interval: {
          m: 5
        }
      }
    }
  },
  'inside-archives': {
    isEnabled: true
  },
  'inside-catalog': {
    descriptionKey: 'labs_categories'
  },
  'inside-comments': {
    mentionsEnabled: true
  },
  'inside-edition': {
    duplicateEnabled: true
  },
  'inside-events': {
    subscriptionEnabled: true
  },
  'inside-newcomers': {
    extraFields: [
      {
        field: 'pharmacy_name',
        data: data => data?.pharmacy_name,
        class: 'name'
      }
    ]
  },
  'inside-news': {
    bookmarkEnabled: false,
    minimalDate: true
  },
  'inside-users': {
    csvImport: true,
    extraFields: ['pharmacy_name', 'cip_code', 'cip_key'],
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'password', restrictions: [], icon: 'restricted' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        requestFields: ['uuid', 'firstname', 'lastname', 'image', 'function']
      }
    }
  }
}
