import { onMounted } from 'vue'
import { getAppInstance } from '@inside-core/helpers/getAppInstance'

import LabModal from '../components/labs/LabModal'
import ProductModal from '../components/products/ProductModal'
import ProductCard from '../components/products/ProductCard'

export function useGlobalComponents() {
  const app = getAppInstance()

  onMounted(() => {
    app.component('lab-modal', LabModal)
    app.component('product-modal', ProductModal)
    app.component('product-card', ProductCard)
  })
}
