<?php

namespace Inside\OBPH\Listeners;

use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Events\ContentFullyUpdatedEvent;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\OBPH\Services\CIPKeyGenerator;

final class UsersCIPKeyGenerateListener
{
    public function handle(ContentFullyInsertedEvent | ContentFullyUpdatedEvent $event): void
    {
        $model = $event->model;

        if (! $model instanceof Users) {
            return;
        }

        $cipKey = $model->cip_code ? CIPKeyGenerator::generateKey($model->cip_code) : null;

        if ($model->cip_key === $cipKey) {
            return;
        }

        $bridge = new BridgeContent();
        $bridge->contentUpdate('users', [
            'uuid' => $model->uuid,
            'cip_key' => $cipKey,
            'cip_code' => $model->cip_code,
        ]);
    }
}
