<?php

return [
    'logo' => [
        'showLogo' => true,
        'logoUrl' => 'vendor/maecia/obph-back/resources/assets/img/newsletter/logo.png',
        'logoWidth' => 150,
    ],
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => '',
    ],
    'banner' => [
        'backgroundImageUrl' => 'vendor/maecia/obph-back/resources/assets/img/newsletter/banner.jpg',
        'backgroundColor' => '#fff',
        'bannerWidth' => 700,
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_intro',
        'textColor' => '#2C3E50',
        'showGreetings' => false,
    ],
    'sections' => [
        'news' => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'sectionType' => 'news',
            'types' => ['news'],
            'fieldLabel' => [
                'news' => [
                    'fr' => 'Actualités à la une',
                ],
            ],
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#318A8B',
            'showIntroduction' => true,

            'link' => [
                'sectionLinkUrl' => 'actualites',
                'sectionTextColor' => '#318A8B',
                'sectionLinkStrKey' => 'newsletter.news_link',
            ],
        ],
        'events' => [
            'sectionTitleStrKey' => 'Agenda - Dates à retenir',
            'types' => ['events'],
            'fieldLabel' => [
                'events' => [
                    'fr' => 'Événements',
                ],
            ],
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#318A8B',
            'link' => [
                'sectionLinkUrl' => 'evenements',
                'sectionTextColor' => '#318A8B',
                'sectionLinkStrKey' => 'Voir toutes les dates',
            ],
        ],
        'documents' => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types' => ['documents'],
            'fieldLabel' => [
                'documents' => [
                    'fr' => 'Documents',
                ],
            ],
            'imageStyle' => 'medium',
            'leftLineColor' => '#318A8B',
            'link' => [
                'sectionLinkStrKey' => 'Voir toutes les ressources',
                'sectionLinkUrl' => 'bibliotheque',
                'sectionTextColor' => '#318A8B',
            ],
        ],
        'new_members' => [
            'sectionTitleStrKey' => 'newsletter.new_members_title',
            'introductionLength' => 50,
            'introductionFieldName' => 'function',
            'types' => ['movements'],
            'fieldLabel' => [
                'movements' => [
                    'fr' => 'Mouvements',
                ],
            ],
            'link' => [
                'sectionLinkUrl' => 'mouvements',
                'sectionTextColor' => '#318A8B',
                'sectionLinkStrKey' => 'newsletter.see_all_new_members',
            ],
        ],
    ],
    'socials' => [
        'backgroundColor' => '#009dc5',
        'links' => [
            'linkedin' => [
                'url' => 'https://www.linkedin.com/company/wellpharma-groupement/',
            ],
            'link' => [
                'titleStrKey' => 'Wellpharma',
                'url' => 'https://www.objectif-pharma.com/',
            ],
        ],
    ],
    'footer' => [
        'backgroundColor' => '#F0F0F0',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning',
    ],
];
