<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class ModifySignsFilterTitleLabs extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'labs',
            fieldName: 'signs',
            options: [
                'name' => 'signs',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 1,
                'filter_widget' => 'checkboxesgroup',
                'filter_order' => 1,
                'filter_category' => '',
                'title' => [
                    'fr' => 'Entité(s)',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['signs'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
            weight: 3
        );
    }
}
