<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class EditProductsStatusesRequireInProductsInformations extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'products_informations',
            fieldName: 'products_statuses',
            options: [
                'name' => 'products_statuses',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 1,
                'filter_widget' => 'checkboxesgroup',
                'filter_order' => 1,
                'filter_category' => '',
                'title' => [
                    'fr' => 'Produit(s)',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['products_statuses'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
            weight: 3
        );
    }
}
