<?php

use Illuminate\Support\Facades\Artisan;
use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Host\Bridge\BridgeContent;

class UpdateProductsFilters extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $bridgeContentType = new BridgeContentType();
        $bridgeContent = new BridgeContent();
        $filters = [
            'products_brands' => [
                'title' => 'Enseigne',
                'weight' => 2,
                'required' => false,
                'values' => [
                    'wellpharma',
                    'Anton&Willem',
                ]
            ],
            'products_statuses' => [
                'title' => 'Produit',
                'weight' => 3,
                'required' => true,
                'values' => [
                    'Aromathérapie',
                    'Beauté',
                    'Circulation',
                    'Confort',
                    'Digestion',
                    'Forme - Immunité',
                    'Grossesse - Bébé',
                    'Hygiène',
                    'Minceur',
                    'Sérénité',
                    'Apithérapie',
                    'Phytothérapie',
                    'Tisanes'
                ]
            ],
            'products_categories' => [
                'title' => 'Catégorie',
                'weight' => 1,
                'required' => true,
                'values' => [
                    'Produit',
                    'Accessoire'
                ]
            ],
            'products_accessories' => [
                'title' => 'Accessoire',
                'weight' => 4,
                'required' => false,
                'values' => [
                    'Animations',
                    'Blouses',
                    'Club',
                    'Fournitures',
                    'Sacs',
                    'Services',
                    'Vitrine',
                    'PLV',
                    'Sacs'
                ]
            ],
        ];

        collect($filters)->each(
            function ($properties, $type) use ($bridgeContent, $bridgeContentType) {
                if (isset($properties['title'])) {
                    $bridgeContentType->contentTypeUpdateOrCreate(
                        type: $type,
                        options: [
                            'name' => $type,
                            'translatable' => true,
                            'searchable' => true,
                            'global_searchable' => false,
                            'aliasable' => false,
                            'permissible' => true,
                            'categorizable' => true,
                            'listing_type' => 'taxo',
                            'title' => [
                                'fr' => $properties['title'],
                            ],
                        ],
                        fields: []
                    );
                    $bridgeContentType->contentTypeCreateOrUpdateField(
                        type: 'products_informations',
                        fieldName: $type,
                        options: [
                            'name' => $type,
                            'searchable' => true,
                            'translatable' => false,
                            'search_result_field' => true,
                            'searchable_filter' => true,
                            'required' => $properties['required'],
                            'weight' => $properties['weight'],
                            'filter_widget' => 'checkboxesgroup',
                            'filter_order' => $properties['weight'],
                            'filter_category' => '',
                            'title' => [
                                'fr' => "$properties[title](s)",
                            ],
                            'widget' => [
                                'type' => BridgeContentType::SELECT_WIDGET,
                                'settings' => [],
                                'weight' => $properties['weight'],
                            ],
                            'type' => BridgeContentType::REFERENCE_FIELD,
                            'settings' => [
                                'target_type' => [$type],
                                'cardinality' => -1,
                            ],
                            'selectable_all' => true,
                        ],
                        entityTypeId: 'node',
                        weight: $properties['weight']
                    );
                    Artisan::call('models:rebuild');
                }

                type_to_class($type)::all()->each(
                    fn ($model) => $bridgeContent->contentDelete($type, $model->uuid)
                );

                collect($properties['values'])->each(
                    fn ($title) => $bridgeContent->contentInsert(
                        type: $type,
                        data: [
                            'title' => $title
                        ]
                    )
                );
            }
        );

        $bridgeContentType->changeContentTypeTitle(
            type: 'products_informations',
            entityTypeId: 'node',
            titles: ['fr' => 'Ajouter produit']
        );

        type_to_class('products_informations')::all()->each(
            fn ($model) => $bridgeContent->contentDelete('products_informations', $model->uuid)
        );
        $this->finishUp();
    }
}
