<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

class SeedProductsInformationsReferences extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $bridge = new BridgeContent();

        collect([
            'products_statuses' => [
                'Biocide',
                'Complément alimentaire - Complexe',
                'Complément alimentaire - Mono ingrédient',
                'Complément alimentaire - Probiotiques',
                'Cosmétique',
                'Dispositif médical',
            ],
            'products_categories' => [
                'Aromathérapie',
                'Beauté',
                'Circulation',
                'Confort',
                'Digestion',
                'Forme - Immunité',
                'Grossesse - Bébé',
                'Hygiène',
                'Minceur',
                'Sérénité',
            ],
        ])->each(
            fn (array $values, string $contentType) =>
                collect($values)->each(
                    fn ($value) => $bridge->contentInsert(
                        type: $contentType,
                        data: [
                            'title' => $value
                        ]
                    )
                )
        );

        $this->finishUp();
    }
}
