<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class AddHideInDirectoryFieldToUsers extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridge->contentTypeCreateOrUpdateField('users', 'hide_in_directory', [
            'name' => 'hide_in_directory',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 18,
            'title' => [
                'fr' => 'Ne pas afficher dans l\'annuaire',
            ],
            'description' => [
                'fr' => 'Permet de de masquer l\'affichage de certains utilisateurs sur l\'annuaire',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => 18,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ]);

        Artisan::call("models:rebuild");

        $bridge = new BridgeContent();

        Users::whereNull('hide_in_directory')->each(fn ($users) => $bridge->contentUpdate('users', ['uuid' => $users->uuid, 'hide_in_directory' => 0]));
    }
}
