<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class allowFetchedContentsInTabsPages extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->updateFieldOptions('tabs_pages', 'content', [
            'target_type' => [
                'text',
                'text_two_columns',
                'text_with_image',
                'separator',
                'file',
                'slider',
                'image',
                'video',
                'map',
                'accordion',
                'call_to_action',
                'button',
                'html',
                'tweet',
                'fetched_contents',
            ]
        ]);
    }

    public function down(): void
    {
    }
}
