<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

final class FixUsersIsMaintenance extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        Users::query()
            ->whereNull('is_maintenance')
            ->pluck('uuid')
            ->each(fn (string $uuid) => $bridge->contentUpdate('users', ['uuid' => $uuid, 'is_maintenance' => false]));
    }
}
