<?php

return [
    'types'  => [
        'news'      => [
            'category' => 'news_categories',
            'comments' => false,
            'likes'    => false,
        ],
        'events'    => [
            'category' => 'events_categories',
            'comments' => true,
            'likes'    => false,
        ],
        'documents' => [
            'category' => 'folders',
            'comments' => false,
            'likes' => true,
        ],
        'pages'    => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'forms'    => [
            'category' => null,
            'comments' => true,
            'likes'    => true,
        ],
        'labs' => [
            'category' => 'labs_categories',
            'comments' => false,
            'likes'    => false,
        ],
        'tabs' => [
            'category' => 'tabs_spaces',
            'comments' => false,
            'likes'    => false,
        ],
        'tabs_pages' => [
            'category' => 'tabs',
            'comments' => false,
            'likes'    => false,
        ],
    ],
    'export' => [
        'contents'       => [
            'headers'    => [
                'uuid'         => 'UUID',
                'content_type' => 'Content type',
                'title'        => 'Title',
                'edit'         => 'Edit link',
            ],
            'presenters' => [
                'edit' => function ($value, $model) {
                    return env('APP_URL').'/edit/'.class_to_type($model).'/'.$model->uuid;
                },
            ],
        ],
        'users'          => [
            'headers' => [
                'email'     => 'Mail address',
                'full_name' => 'Full name',
            ],
        ],
        'user_visits' => [
            'headers'    => [],
        ],
        'authentication' => [
            'headers' => [],
        ],
    ]
];
