<?php

namespace Inside\OBPH\Providers;

use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Events\ContentFullyUpdatedEvent;
use Inside\OBPH\Listeners\UsersCIPKeyGenerateListener;
use Inside\Support\EventServiceProvider as BaseServiceProvider;

class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        ContentFullyInsertedEvent::class => [
            UsersCIPKeyGenerateListener::class,
        ],
        ContentFullyUpdatedEvent::class => [
            UsersCIPKeyGenerateListener::class,
        ],
    ];

    public function register(): void
    {
        $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
        $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
        $this->mergeConfigFrom(__DIR__.'/../../config/csv.php', 'csv');
        $this->mergeConfigFrom(__DIR__.'/../../config/xlsx.php', 'xlsx');
        $this->mergeConfigTo(__DIR__.'/../../config/feed.php', 'feed');
        $this->mergeConfigTo(__DIR__.'/../../config/statistics.php', 'statistics');
    }
}
