<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class ModifyBrandsFilterTitleProductInformation extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'products_informations',
            fieldName: 'products_brands',
            options: [
                'name' => 'products_brands',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 4,
                'filter_widget' => 'checkboxesgroup',
                'filter_order' => 1,
                'filter_category' => '',
                'title' => [
                    'fr' => 'Entité(s)',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['products_brands'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
            weight: 3
        );
    }
}
