<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\Users;

class UpdateObphShortcut extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'tools',
            fieldName: 'visible_homepage',
            options: [
                'name' => 'visible_homepage',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'fr' => 'Afficher sur la page d\'accueil',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 2,
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ],
            weight: 2
        );

        $toolsTitles = [
            'My Pilot' => 0,
            'PandaLab' => 1,
            'Faks' => 2,
            'Club wellpharma' => 3,
            'Uberall' => 4,
            'Objectif Privilège' => 5,
        ];

        $tools = Tools::query()
            ->whereIn('title', array_keys($toolsTitles))
            ->pluck('title', 'uuid');

        $bridge = new BridgeContent();

        collect($tools)->each(fn ($title, $uuid) => $bridge->contentUpdate(
            type: 'tools',
            data: [
                'uuid' => $uuid,
                'title' => $title,
                'weight' => $toolsTitles[$title],
                'visible_homepage' => true,
            ]
        ));
    }
}
