<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Host\Bridge\BridgeContent;

class AddProductsBrandsContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $bridgeContentType = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        $bridgeContentType->contentTypeCreate(
            type: "products_brands",
            entityTypeId: 'node',
            options: [
                'name' => 'products_brands',
                'translatable' => true,
                'searchable' => true,
                'global_searchable' => false,
                'aliasable' => false,
                'permissible' => true,
                'categorizable' => true,
                'listing_type' => 'taxo',
                'title' => [
                    'fr' => 'Enseigne',
                ],
            ],
            fields: []
        );

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'products_informations',
            fieldName: 'products_brands',
            options: [
                'name' => 'products_brands',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 2,
                'filter_widget' => 'checkboxesgroup',
                'filter_order' => 2,
                'filter_category' => '',
                'title' => [
                    'fr' => 'Enseigne(s)',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 4,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['products_brands'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
            entityTypeId: 'node',
            weight: 4
        );

        collect([
            'Wellpharma',
            'Anton&Willem'
        ])->each(
            fn ($value) => $bridgeContent->contentInsert(
                type: 'products_brands',
                data: [
                    'title' => $value
                ]
            )
        );

        $this->finishUp();
    }
}
