<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

final class CreateCustomPages extends Migration
{
    public function up(): void
    {
        if (! Schema::hasModel('custom')) {
            return;
        }

        $existing = Custom::query()
            ->where('redirection_page', 'ProductsListingPage')
            ->exists();

        if ($existing) {
            return;
        }

        $bridge = new BridgeContent();
        $custom = [
            'title' => 'Annuaire des produits',
            'custom_slug' => 'products-listing',
            'redirection_page' => 'ProductsListingPage',
            'langcode' => 'fr'
        ];

        $bridge->contentInsert('custom', $custom);
    }
}
