<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddProductsInformationsContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $bridge = new BridgeContentType();

        collect([
            'products_statuses' => 'Statuts',
            'products_categories' => 'Categories',
        ])->each(
            fn (string $title, $contentType) => $bridge->contentTypeCreate(
                type: $contentType,
                entityTypeId: 'node',
                options: [
                    'name' => $contentType,
                    'translatable' => true,
                    'searchable' => true,
                    'global_searchable' => false,
                    'aliasable' => false,
                    'permissible' => true,
                    'categorizable' => true,
                    'listing_type' => 'taxo',
                    'title' => [
                        'fr' => $title,
                    ],
                ],
                fields: []
            )
        );

        $bridge->contentTypeCreate(
            type: 'products_informations',
            entityTypeId: 'node',
            options: [
                'name' => 'products_informations',
                'translatable' => true,
                'searchable' => true,
                'global_searchable' => false,
                'aliasable' => false,
                'permissible' => true,
                'categorizable' => false,
                'listing_type' => 'taxo',
                'title' => [
                    'fr' => 'Informations de produits',
                ],
            ],
            fields: [
                [
                    'name' => 'image',
                    'translatable' => false,
                    'searchable' => true,
                    'search_result_field' => true,
                    'searchable_filter' => false,
                    'required' => true,
                    'weight' => 0,
                    'title' => [
                        'fr' => 'Image de présentation',
                    ],
                    'widget' => [
                        'type' => BridgeContentType::IMAGE_WIDGET,
                        'settings' => [
                            'progress_indicator' => 'throbber',
                            'preview_image_style' => 'thumbnail',
                        ],
                        'weight' => 0,
                    ],
                    'type' => BridgeContentType::IMAGE_FIELD,
                    'settings' => [
                        'uri_scheme' => 'public',
                        'default_image' => [
                            'uuid' => '',
                            'alt' => '',
                            'title' => '',
                            'width' => null,
                            'height' => null,
                        ],
                        'target_type' => 'file',
                        'display_field' => false,
                        'display_default' => false,
                        'cardinality' => 1,
                    ],
                ],
                [
                    'name' => 'products_statuses',
                    'searchable' => true,
                    'translatable' => false,
                    'search_result_field' => true,
                    'searchable_filter' => true,
                    'required' => true,
                    'weight' => 1,
                    'filter_widget' => 'checkboxesgroup',
                    'filter_order' => 1,
                    'filter_category' => '',
                    'title' => [
                        'fr' => 'Statut(s)',
                    ],
                    'widget' => [
                        'type' => BridgeContentType::SELECT_WIDGET,
                        'settings' => [],
                        'weight' => 1,
                    ],
                    'type' => BridgeContentType::REFERENCE_FIELD,
                    'settings' => [
                        'target_type' => ['products_statuses'],
                        'cardinality' => -1,
                    ],
                    'selectable_all' => true,
                ],
                [
                    'name' => 'products_categories',
                    'searchable' => true,
                    'translatable' => false,
                    'search_result_field' => true,
                    'searchable_filter' => true,
                    'required' => true,
                    'weight' => 2,
                    'filter_widget' => 'checkboxesgroup',
                    'filter_order' => 2,
                    'filter_category' => '',
                    'title' => [
                        'fr' => 'Categorie(s)',
                    ],
                    'widget' => [
                        'type' => BridgeContentType::SELECT_WIDGET,
                        'settings' => [],
                        'weight' => 2,
                    ],
                    'type' => BridgeContentType::REFERENCE_FIELD,
                    'settings' => [
                        'target_type' => ['products_categories'],
                        'cardinality' => -1,
                    ],
                    'selectable_all' => true,
                ],
                [
                    'name' => 'content',
                    'searchable' => true,
                    'translatable' => false,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 3,
                    'title' => [
                        'fr' => 'Contenu',
                    ],
                    'description' => [
                        'fr' => 'Sélectionnez les différents types de paragraphes que vous voulez faire remonter sur la page',
                    ],
                    'widget' => [
                        'type' => BridgeContentType::SECTION_WIDGET,
                        'settings' => [
                            'title' => 'Paragraphe',
                            'title_plural' => 'Paragraphes',
                            'edit_mode' => 'open',
                            'add_mode' => 'dropdown',
                            'form_display_mode' => 'default',
                            'default_paragraph_type' => '',
                        ],
                        'weight' => 3,
                    ],
                    'type' => BridgeContentType::SECTION_FIELD,
                    'settings' => [
                        'target_type' => [
                            'text',
                            'text_two_columns',
                            'text_with_image',
                            'separator',
                            'file',
                            'slider',
                            'image',
                            'video',
                            'map',
                            'accordion',
                            'call_to_action',
                            'button',
                            'html',
                            'tweet',
                            'fetched_contents',
                        ],
                        'cardinality' => -1,
                    ],
                ],
            ]
        );


        $this->finishUp();
    }
}
