<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Users;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;
use Inside\Notify\Models\NotificationTypeRole;
use Inside\Permission\Models\Role;

class RemoveSaNotificationTypes extends Migration
{
    public function up(): void
    {
        // [nom de la personne] a commenté votre actualité [nom du contenu]
        $notificationTypes[] = NotificationType::where(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Comments',
                'action' => 'contentCommented',
                'type' => 'global',
                'condition' => 'parent_type:news',
                'multiple' => true,
                'profile' => false,
                'role' => true,
            ]
        )->first();

        // [nom de la personne] a commenté votre actualité [nom du contenu]
        $notificationTypes[] = NotificationType::where(
            [
                'via' => 'email',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Comments',
                'action' => 'contentCommented',
                'type' => 'global',
                'condition' => 'parent_type:news',
                'multiple' => true,
                'profile' => false,
                'role' => true
            ]
        )->first();

        // [nom de la personne] a répondu à votre commentaire
        $notificationTypes[] = NotificationType::where(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Content\Events\CommentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Comments',
                'action' => 'commentCommented',
                'type' => 'global',
                'condition' => null,
                'multiple' => true,
                'profile' => false,
                'language' => false,
                'role' => true
            ]
        )->first();

        // [nom de la personne] a répondu à votre commentaire
        $notificationTypes[] = NotificationType::where(
            [
                'via' => 'email',
                'default' => true,
                'event' => 'Inside\Content\Events\CommentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Comments',
                'action' => 'commentCommented',
                'type' => 'global',
                'condition' => null,
                'multiple' => true,
                'profile' => false,
                'language' => false,
                'role' => true,
            ]
        )->first();

        /** @var Role $superAdminRole */
        $superAdminRole = Role::where('name', 'super_administrator')->first();

        /** @var NotificationType[] $notificationTypes */
        foreach ($notificationTypes as $notificationType) {
            Users::all()->each(
                function ($user) use ($notificationType) {
                    /** @var ?NotificationSubscriber $notificationSubscriber */
                    $notificationSubscriber = NotificationSubscriber::query()->where(
                        [
                            'user_uuid' => $user->uuid,
                            'notification_type_id' => $notificationType->id,
                        ]
                    )->first();

                    $notificationSubscriber?->delete();
                }
            );

            $notificationType->delete();

            if ($notificationType->role) {
                /** @var ?NotificationTypeRole $notificationTypeRole */
                $notificationTypeRole = NotificationTypeRole::where(
                    [
                        'role_id' => $superAdminRole->id,
                        'notification_type_id' => $notificationType->id,
                    ]
                )->first();

                $notificationTypeRole?->delete();
            }
        }
    }
}
