<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Users;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;
use Inside\Notify\Models\NotificationTypeRole;
use Inside\Permission\Models\Role;

class AddCommentAndLikeNotifications extends Migration
{
    public function up(): void
    {
        // [nom de la personne] a commenté votre actualité [nom du contenu]
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => true,
                'event'     => 'Inside\Content\Events\ContentCreatedEvent',
                'model'     => 'Inside\Content\Models\Contents\Comments',
                'action'    => 'contentCommented',
                'type'      => 'global',
                'condition' => 'parent_type:news|author:CURRENT_USER',
                'multiple'  => true,
                'profile'   => true,
                'data' => [
                    'title'         => 'notifications.create.comment.content.title',
                    'description'   => 'notifications.create.comment.content.description',
                    'icon'          => 'comment',
                    'text'          => 'notifications.create.comment.content.<content_type>.text',
                    'fields'        => [
                        'title',
                        'content_type',
                        'notification-data.from' => ['firstname', 'lastname']
                    ],
                ]
            ]
        );

        // [nom de la personne] a commenté votre actualité [nom du contenu]
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'email',
                'default'   => true,
                'event'     => 'Inside\Content\Events\ContentCreatedEvent',
                'model'     => 'Inside\Content\Models\Contents\Comments',
                'action'    => 'contentCommented',
                'type'      => 'global',
                'condition' => 'parent_type:news|author:CURRENT_USER',
                'multiple'  => true,
                'profile'   => true,
                'data' => [
                    'title'         => 'notifications.create.comment.content.title',
                    'description'   => 'notifications.create.comment.content.description',
                    'icon'          => 'comment',
                    'mail'        => [
                        'subject'    => 'notifications.create.comment.content.mail.subject',
                        'text'       => 'notifications.create.comment.content.mail.<content_type>.text',
                        'buttonText' => 'notifications.create.comment.content.mail.buttonText',
                    ],
                    'fields'        => [
                        'title',
                        'content_type',
                        'notification-data.from' => ['firstname', 'lastname']
                    ],
                ]
            ]
        );

        // [nom de la personne] a aimé votre actualité [nom de l’actualité]
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Reaction\Events\ReactionSubscribedEvent',
                'model' => null,
                'action' => 'like',
                'type' => 'system',
                'condition' => 'content_type:news|author:CURRENT_USER',
                'multiple' => true,
                'profile' => false,
                'data' => [
                    'title' => 'notifications.reaction.like.title',
                    'text' => 'notifications.reaction.like.text',
                    'icon' => 'like',
                    'fields' => [
                        'notification-data.from' => ['firstname', 'lastname'],
                        'title'
                    ]
                ],
            ]
        );

        // [nom de la personne] a aimé votre commentaire
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Reaction\Events\ReactionSubscribedEvent',
                'model' => 'Inside\Content\Models\Contents\Comments',
                'action' => 'like',
                'type' => 'system',
                'condition' => 'author:CURRENT_USER',
                'multiple' => true,
                'profile' => false,
                'data' => [
                    'title' => 'notifications.reaction.like.comment.title',
                    'text' => 'notifications.reaction.like.comment.text',
                    'icon' => 'like',
                    'fields' => [
                        'notification-data.from' => ['firstname', 'lastname'],
                        'title'
                    ]
                ],
            ]
        );

        // [nom de la personne] a répondu à votre commentaire
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => true,
                'event'     => 'Inside\Content\Events\CommentCreatedEvent',
                'model'     => 'Inside\Content\Models\Contents\Comments',
                'action'    => 'commentCommented',
                'type'      => 'global',
                'condition' => 'author:CURRENT_USER',
                'multiple'  => true,
                'profile'   => true,
                'language'  => false,
                'data' => [
                    'title'       => 'notifications.create.comment.comment.title',
                    'description' => 'notifications.create.comment.comment.description',
                    'icon'        => 'comment',
                    'text'        => 'notifications.create.comment.comment.<content_type>.text',
                    'fields'      => [
                        'notification-data.from' => ['firstname', 'lastname'],
                        'title',
                        'content_type'
                    ],
                ],
            ]
        );

        // [nom de la personne] a répondu à votre commentaire
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'email',
                'default'   => true,
                'event'     => 'Inside\Content\Events\CommentCreatedEvent',
                'model'     => 'Inside\Content\Models\Contents\Comments',
                'action'    => 'commentCommented',
                'type'      => 'global',
                'condition' => 'author:CURRENT_USER',
                'multiple'  => true,
                'profile'   => true,
                'language'  => false,
                'data' => [
                    'title'       => 'notifications.create.comment.comment.title',
                    'description' => 'notifications.create.comment.comment.description',
                    'icon'        => 'comment',
                    'mail'        => [
                        'subject'    => 'notifications.create.comment.comment.mail.subject',
                        'text'       => 'notifications.create.comment.comment.mail.text',
                        'buttonText' => 'notifications.create.comment.comment.mail.buttonText',
                    ],
                    'fields'      => [
                        'notification-data.from' => ['firstname', 'lastname'],
                        'title',
                        'content_type'
                    ],
                ],
            ]
        );

        // [nom de la personne] a commenté votre actualité [nom du contenu]
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => true,
                'event'     => 'Inside\Content\Events\ContentCreatedEvent',
                'model'     => 'Inside\Content\Models\Contents\Comments',
                'action'    => 'contentCommented',
                'type'      => 'global',
                'condition' => 'parent_type:news',
                'multiple'  => true,
                'profile'   => false,
                'role' => true,
                'data' => [
                    'title'         => 'notifications.super_admin.create.comment.content.title',
                    'description'   => 'notifications.super_admin.create.comment.content.description',
                    'icon'          => 'comment',
                    'text'          => 'notifications.super_admin.create.comment.content.<content_type>.text',
                    'fields'        => [
                        'title',
                        'content_type',
                        'notification-data.from' => ['firstname', 'lastname']
                    ],
                ]
            ]
        );

        // [nom de la personne] a commenté votre actualité [nom du contenu]
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'email',
                'default'   => true,
                'event'     => 'Inside\Content\Events\ContentCreatedEvent',
                'model'     => 'Inside\Content\Models\Contents\Comments',
                'action'    => 'contentCommented',
                'type'      => 'global',
                'condition' => 'parent_type:news',
                'multiple'  => true,
                'profile'   => false,
                'role'      => true,
                'data' => [
                    'title'         => 'notifications.super_admin.create.comment.content.title',
                    'description'   => 'notifications.super_admin.create.comment.content.description',
                    'icon'          => 'comment',
                    'mail'        => [
                        'subject'    => 'notifications.super_admin.create.comment.content.mail.subject',
                        'text'       => 'notifications.super_admin.create.comment.content.mail.<content_type>.text',
                        'buttonText' => 'notifications.super_admin.create.comment.content.mail.buttonText',
                    ],
                    'fields'        => [
                        'title',
                        'content_type',
                        'notification-data.from' => ['firstname', 'lastname']
                    ],
                ]
            ]
        );

        // [nom de la personne] a répondu à votre commentaire
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => true,
                'event'     => 'Inside\Content\Events\CommentCreatedEvent',
                'model'     => 'Inside\Content\Models\Contents\Comments',
                'action'    => 'commentCommented',
                'type'      => 'global',
                'condition' => null,
                'multiple'  => true,
                'profile'   => false,
                'language'  => false,
                'role' => true,
                'data' => [
                    'title'       => 'notifications.super_admin.create.comment.comment.title',
                    'description' => 'notifications.super_admin.create.comment.comment.description',
                    'icon'        => 'comment',
                    'text'        => 'notifications.super_admin.create.comment.comment.<content_type>.text',
                    'fields'      => [
                        'notification-data.from' => ['firstname', 'lastname'],
                        'title',
                        'content_type'
                    ],
                ],
            ]
        );

        // [nom de la personne] a répondu à votre commentaire
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'email',
                'default'   => true,
                'event'     => 'Inside\Content\Events\CommentCreatedEvent',
                'model'     => 'Inside\Content\Models\Contents\Comments',
                'action'    => 'commentCommented',
                'type'      => 'global',
                'condition' => null,
                'multiple'  => true,
                'profile'   => false,
                'language'  => false,
                'role' => true,
                'data' => [
                    'title'       => 'notifications.super_admin.create.comment.comment.title',
                    'description' => 'notifications.super_admin.create.comment.comment.description',
                    'icon'        => 'comment',
                    'mail'        => [
                        'subject'    => 'notifications.super_admin.create.comment.comment.mail.subject',
                        'text'       => 'notifications.super_admin.create.comment.comment.mail.text',
                        'buttonText' => 'notifications.super_admin.create.comment.comment.mail.buttonText',
                    ],
                    'fields'      => [
                        'notification-data.from' => ['firstname', 'lastname'],
                        'title',
                        'content_type'
                    ],
                ],
            ]
        );

        /** @var Role $superAdminRole */
        $superAdminRole = Role::where('name', 'super_administrator')->first();
        /** @var NotificationType[] $notificationTypes */
        foreach ($notificationTypes as $notificationType) {
            Users::all()->each(
                function ($user) use ($notificationType) {
                    NotificationSubscriber::firstOrCreate(
                        [
                            'user_uuid' => $user->uuid,
                            'notification_type_id' => $notificationType->id,
                        ]
                    );
                }
            );

            if ($notificationType->role) {
                NotificationTypeRole::firstOrCreate(
                    [
                        'role_id' => $superAdminRole->id,
                        'notification_type_id' => $notificationType->id,
                    ]
                );
            }
        }
    }
}
