<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldCommentsToEventsAndNews extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        collect(['news', 'events'])->each(
            fn ($contentType) => $bridge
            ->contentTypeCreateOrUpdateField($contentType, 'comments', [
                'name' => 'comments',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 6,
                'title' => [
                    'fr' => 'Commentaires',
                ],
                'widget' => [
                    'hidden' => true,
                ],
                'type' => BridgeContentType::COMMENT_FIELD,
                'settings' => [
                    'comment_type' => 'comments',
                    'cardinality' => 1,
                ],
            ])
        );
    }
}
