<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class CreateProvidersFilter extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $bridge = new BridgeContentType();

        $this->migrateContent('providers');
        $bridge->contentTypeCreateOrUpdateField('labs', 'providers', [
            'name' => 'providers',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 1,
            'filter_widget' => 'checkboxesgroup',
            'filter_order' => 3,
            'filter_category' => '',
            'title' => [
                'fr' => 'Prestataires',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => -2,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['providers'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ]);

        $this->finishUp();
    }
}
