<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class CreateInstanceContentTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('user', 'user', 'mobile_phone');

        $this->migrateContent('folders');
        $this->migrateContent('documents');
        $this->migrateContent('tools_categories');
        $this->migrateContent('tools');
        $this->migrateContent('flash_news');
        $this->migrateContent('signs');
        $this->migrateContent('users');
        $this->migrateContent('custom');
        $this->migrateContent('pages');
        $this->migrateContent('news_categories');
        $this->migrateContent('news');
        $this->migrateContent('events_categories');
        $this->migrateContent('events');
        $this->migrateContent('blocks');
        $this->migrateContent('small_blocks');
        $this->migrateContent('tabs_spaces_categories');
        $this->migrateContent('tabs_spaces');
        $this->migrateContent('tabs');
        $this->migrateContent('tabs_pages');
        $this->migrateContent('labs_categories');
        $this->migrateContent('labs');

        $this->finishUp();
    }
}
