<?php

use Inside\Host\Bridge\BridgeContent;

if (! function_exists('get_entity')) {
    function get_entity(?string $value, BridgeContent $bridge, string $bundle): ?string
    {
        $value = trim(ucwords(strtolower($value ?? '')));

        if (empty($value)) {
            return null;
        }

        $existing = type_to_class($bundle)::where('title', $value)->first()?->uuid;

        return $existing ?? $bridge->contentInsert($bundle, ['title' => $value]);
    }
}

return [
    'files' => [
        'obph' => [
            'path' => env('XLSX_CUSTOM_PATH', __DIR__.'/../../../../imports/users.xlsx'),
            'fields' => [
                'name' => fn (array $record) => trim($record['mail prioritaire']),
                'mail' => fn (array $record) => trim($record['mail prioritaire']),
                'firstname' => fn (array $record) => ucwords($record['prenom']),
                'lastname' => fn (array $record) => ucwords($record['nom']),
                'pharmacy_name' => fn (array $record) => ucwords($record['nom de la pharmacie']),
                'phone' => fn (array $record) => trim($record['tel']),
                'zip_code' => fn (array $record) => trim($record['cp']),
                'city' => fn (array $record) => trim($record['ville']),
                'signs' => fn (array $record, BridgeContent $bridge) => get_entity($record['entité'], $bridge, 'signs'),
                'cip_code' => fn (array $record) => trim($record['cip']),
                'status' => fn () => true,
            ],
            'original_fields' => [
                'mail prioritaire' => 'mail',
                'prenom' => 'firstname',
                'nom' => 'lastname',
                'nom de la pharmacie' => 'company',
                'tel' => 'word',
                'cp' => 'word',
                'ville' => 'word',
                'entité' => 'word',
                'cip' => 'word',
            ],
        ],
    ],
];
