import SpacePage from '../pages/spaces/SpacePage'
import SpacesCategoryPage from '../pages/spaces/SpacesCategoryPage'
import {
  fetchSpacesPage,
  fetchSpaceCategory
} from '../components/spaces/spaces'

import TabSpacePage from '../pages/tab-spaces/TabSpacePage'
import { fetchTabSpacesPage } from '../components/tab-spaces'

import NewsletterPage from '../pages/newsletters/NewsletterPage'
import { fetchNewsletter } from '../fetch'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'SpacesListingPage',
    path: '/espaces',
    component: () => import('../pages/spaces/SpacesListingPage')
  },
  {
    name: 'SpacesCategoryPage',
    path: '/espaces/:slug',
    component: withFetch(SpacesCategoryPage, { size: 'xxl' })(
      fetchSpaceCategory
    )
  },
  {
    name: 'SpacePage',
    path: '/espace/:slug',
    component: withFetch(SpacePage, { size: 'xxl' })(fetchSpacesPage)
  },
  {
    name: 'TabSpaceListingPage',
    path: '/espaces-onglets',
    component: () => import('../pages/tab-spaces/TabsSpaceListingPage')
  },
  {
    name: 'TabSpacePage',
    path: '/espaces-onglets/:slug',
    component: withFetch(TabSpacePage, { size: 'xxl', watch: true })(
      fetchTabSpacesPage
    )
  },
  {
    name: 'JobsListingPage',
    props: {
      bannerData: { add: ['job_offers', 'services'] }
    }
  },
  {
    name: 'NewslettersListingPage',
    path: '/newsletters',
    component: () => import('../pages/newsletters/NewslettersListingPage'),
    meta: { customSlug: 'newsletters-listing' }
  },
  {
    name: 'NewsletterPage',
    path: '/newsletters/:slug',
    component: withFetch(NewsletterPage, { size: 'xxl' })(fetchNewsletter)
  },
  {
    name: 'WallsListingPage',
    meta: { disabled: false, customSlug: 'walls' }
  },
  {
    name: 'WallPage',
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
