import { http } from '@inside-library/helpers/Http'

export const fetchTabSpacesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/tabs_collections', {
      fields: [
        'uuid',
        'title',
        'banner',
        'introduction',
        'admin',
        'content_type'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
