import { http } from '@inside-library/helpers/Http'
import get from 'lodash/get'

export default {
  /** SPACES */
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'SpacesListingPage'
    })
  },
  spacesCategories: {
    add: async ({ data }) => {
      try {
        const { data: spacesCategories } = await http.get(
          'content/spaces_categories',
          {
            fields: ['uuid', 'title', 'slug'],
            filters: { 'uuid:eq': data.uuid }
          }
        )

        const slug = get(spacesCategories, [0, 'slug', 0])

        return {
          name: 'SpacesCategoryPage',
          params: { slug }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    delete: () => ({
      name: 'SpacesListingPage'
    })
  },
  spacesFolders: {
    add: async ({ data }) => {
      try {
        const { data: folderData } = await http.get('content/spaces_folders', {
          filters: {
            'uuid:eq': data.uuid
          },
          fields: ['uuid', 'title', { spaces: ['uuid', 'title', 'slug'] }]
        })

        return {
          name: 'SpacePage',
          params: {
            slug: folderData[0]?.spaces?.data?.[0].slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data: folderData } = await http.get('content/spaces_folders', {
          filters: {
            'uuid:eq': uuid
          },
          fields: ['uuid', 'title', { spaces: ['uuid', 'title', 'slug'] }]
        })

        return {
          name: 'SpacePage',
          params: {
            slug: folderData[0]?.spaces?.data?.[0].slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  spacesFiles: {
    add: async ({ data }) => {
      try {
        const { data: filesData } = await http.get('content/spaces_files', {
          filters: {
            'uuid:eq': data.uuid
          },
          fields: [
            { spaces_folders: ['uuid', { spaces: ['uuid', 'title', 'slug'] }] }
          ]
        })

        return {
          name: 'SpacePage',
          params: {
            slug:
              filesData[0]?.spaces_folders?.data?.[0]?.spaces?.data?.[0].slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data: filesData } = await http.get('content/spaces_files', {
          filters: {
            'uuid:eq': uuid
          },
          fields: [
            { spaces_folders: ['uuid', { spaces: ['uuid', 'title', 'slug'] }] }
          ]
        })

        return {
          name: 'SpacePage',
          params: {
            slug:
              filesData[0]?.spaces_folders?.data?.[0]?.spaces?.data?.[0].slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    globalSearch: ({ vm, data }) => ({
      action: () =>
        vm.triggerModal(
          'doc-ged',
          'fetch',
          { item: data, content: data.content_type },
          { layout: 'right', transition: 'fadeInLeft' }
        )
    })
  },
  /** TABS SPACE */
  tabsCollections: {
    add: ({ data }) => ({
      name: 'TabSpacePage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'TabSpaceListingPage'
    })
  },
  tabs: {
    add: async ({ data }) => {
      try {
        const { data: tab } = await http.get('content/tabs', {
          filters: {
            'uuid:eq': data.uuid
          },
          fields: [{ tabs_collections: ['uuid', 'title', 'slug'] }]
        })

        return {
          name: 'TabSpacePage',
          params: {
            slug: tab[0]?.tabs_collections?.slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: async ({ data }) => {
      try {
        const { data: tab } = await http.get('content/tabs', {
          filters: {
            'uuid:eq': data.uuid
          },
          fields: [{ tabs_collections: ['uuid', 'title', 'slug'] }]
        })

        return {
          name: 'TabSpacePage',
          params: {
            slug: tab[0]?.tabs_collections?.slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  tabsPages: {
    add: async ({ data }) => {
      try {
        const { data: page } = await http.get('content/tabs_pages', {
          filters: {
            'uuid:eq': data.uuid
          },
          fields: [
            'uuid',
            'title',
            {
              tabs: [
                'uuid',
                'title',
                { tabs_collections: ['uuid', 'title', 'slug'] }
              ]
            }
          ]
        })

        return {
          name: 'TabSpacePage',
          params: {
            slug: page[0]?.tabs?.tabs_collections?.slug[0]
          },
          query: { page: data.uuid }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: async ({ data }) => {
      try {
        const { data: page } = await http.get('content/tabs_pages', {
          filters: {
            'uuid:eq': data.uuid
          },
          fields: [
            'uuid',
            'title',
            {
              tabs: [
                'uuid',
                'title',
                { tabs_collections: ['uuid', 'title', 'slug'] }
              ]
            }
          ]
        })

        return {
          name: 'TabSpacePage',
          params: {
            slug: page[0]?.tabs.tabs_collections?.slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  /** JOBS */
  jobOffers: {
    add: () => ({
      name: 'JobsListingPage'
    }),
    delete: () => ({
      name: 'JobsListingPage'
    })
  },
  services: {
    add: () => ({
      name: 'JobsListingPage'
    }),
    delete: () => ({
      name: 'JobsListingPage'
    })
  }
}
