import { markRaw } from 'vue'

import { getContentImage } from '@inside-library/helpers/Image'
import { IconText } from 'inside-collection/atoms'

export default {
  'inside-administration': {
    disabledAdvancedSettingsFields: [
      'ged_enable_likes',
      'events_enable_comments',
      'events_enable_likes'
    ]
  },
  'inside-auth': {
    loginForm: {
      userId: {
        modelName: 'name',
        inputType: 'text'
      }
    }
  },
  'inside-comments': {
    mentionsEnabled: true
  },
  'inside-jobs': {
    mainContentType: 'job_offers',
    modalName: 'job-offers',
    extraFields: [{ services: ['title', 'uuid'] }],
    categoriesFields: [
      {
        services: {
          fields: ['title', 'uuid'],
          filters: { 'status:eq': 1, sort: 'title:asc' }
        }
      }
    ],
    cardOverrides: (data, { addItemAfter }) => {
      addItemAfter('contract', {
        id: 'services',
        class: 'services',
        tag: markRaw(IconText),
        data: { icon: 'holidays' },
        value: data?.services?.title
      })
    }
  },
  'inside-layouts': {
    firstConnectionModalEnabled: true
  },
  'inside-news': {
    showBookmarks: false,
    bookmarkEnabled: false
  },
  'inside-users': {
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    },
    shortcuts: {
      max: 6
    },
    paragraphs: {
      fetchedContents: {
        listingAttributes: { itemsPerPage: 24 },
        display: () => import('./components/users/UserCard'),
        displayAttributes: ({ item }) => ({
          image: getContentImage(item.image, 'avatar')
        }),
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'mobile_phone',
          'phone',
          'image',
          'function'
        ]
      }
    }
  }
}
