import { http } from '@inside-library/helpers/Http'

export const fetchNewsletter = async ({ $route }) => {
  try {
    const { data } = await http.get('newsletters', {
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchTemplate = async ({ $route }) => {
  try {
    const { data: newsletterUuid } = await http.get('newsletters', {
      filters: { 'slug:eq': $route.params.slug }
    })

    const data = await http.get(
      `newsletters/view/newsletters/${newsletterUuid[0].uuid}`,
      {},
      { json: false }
    )

    return data
  } catch (err) {
    throw new Error(err)
  }
}
