import { http } from '@inside-library/helpers/Http'

export const fetchSpacesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'introduction',
        'contact',
        'organizational_chart',
        'banner',
        'show_job_offers',
        'content',
        {
          spaces_categories: ['uuid', 'title', 'slug']
        },
        {
          users: {
            fields: [
              'firstname',
              'function',
              'image',
              'lastname',
              'phone',
              'status',
              'uuid'
            ]
          }
        },
        {
          blocks: {
            fields: [
              'uuid',
              'title',
              'background_color',
              'image',
              'link',
              'link_label',
              'visible_space',
              'admin',
              'content_type',
              'open_in_new_tab'
            ],
            filters: {
              reverse: true,
              'status:eq': 1,
              sort: 'weight:asc'
            }
          }
        },
        {
          spaces_folders: {
            fields: ['uuid', 'title'],
            filters: {
              reverse: true,
              'status:eq': 1
            }
          }
        },
        {
          tools_categories: {
            fields: [
              'uuid',
              'title',
              'admin',
              'content_type',
              {
                tools: {
                  fields: [
                    'uuid',
                    'title',
                    'has_section',
                    'class',
                    'image',
                    'tools_link',
                    'content_type',
                    'admin'
                  ],
                  filters: { 'status:eq': 1, sort: 'weight:asc', reverse: true }
                }
              }
            ],
            filters: { 'status:eq': 1 }
          }
        },
        {
          news_categories: {
            fields: [
              'uuid',
              'title',
              {
                news: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'chapo',
                    'published_at',
                    'image',
                    'content_type',
                    { news_categories: ['uuid', 'title', 'color'] },
                    { reactions: ['count', { users: ['uuid'] }] },
                    { comments: ['count'] }
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    sort: 'published_at:desc',
                    'published_at:lte': 'now()',
                    limit: 4
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1,
              'published_at:lte': 'now()'
            }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchSpaceCategory = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces_categories', {
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'introduction'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
