<?php

namespace Inside\NFH2\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class UserDefaultToolsListener implements ShouldQueue
{
    public function handle(ContentFullyInsertedEvent $event): void
    {
        if (! $event->model instanceof Users) {
            return;
        }

        $bridge = new BridgeContent();

        $defaultTools = collect([
            "Plateforme achat",
            "Horoquartz",
            "Recrutement",
            "Lyreco",
            "Action logement",
            "Alfresco",
        ]);

        $user = $event->model;

        $toolsUuids = Tools::query()
            ->whereIn('title', $defaultTools)
            ->get()
            ->sortBy(fn (Tools $tool) => $defaultTools->search($tool->title))
            ->pluck('uuid');

        $tools = $user->tools->pluck('uuid')->concat($toolsUuids)->unique()->all();

        $bridge->contentUpdate('users', [
            'uuid' => $user->uuid,
            'tools' => $tools,
        ]);
    }
}
