<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Notify\Models\NotificationType;
use Inside\Permission\Models\Role;

final class RemoveGroupsModule extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        $groupsTables = [
            'group_posts',
            'group_activities',
            'group_members',
            'group_roles',
            'groups',
        ];

        foreach ($groupsTables as $table) {
            Schema::dropIfExists($table);
        }

        $groupsTypes = [
            'groups_documents',
            'groups_folders',
            'groups_posts',
            'groups',
        ];

        foreach ($groupsTypes as $type) {
            if (InsideSchema::hasContentType($type)) {
                $contents = type_to_class($type)::all();

                foreach ($contents as $content) {
                    $bridgeContent->contentDelete($type, $content->uuid);
                }

                if (! $bridgeContentType->contentTypeDelete($type)) {
                    throw new Exception("Failed to delete content type: {$type}");
                }
            }
        }

        $custom = type_to_class('custom')::where('custom_slug', 'groups')->first();

        $bridgeContent->contentDelete('custom', $custom->uuid);

        Role::query()->where('name', 'like', 'group_%')->delete();

        NotificationType::where('type', 'group')->delete();

        DB::table('inside_pivots')->where('related_field', 'groups')->delete();
    }
}
