<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Artisan;

final class MakePhoneEditable extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->updateFieldOptions(
            type: 'users',
            fieldName: 'mobile_phone',
            options: [
                'required' => false,
                'editable' => true,
                'weight' => 6,
            ]
        );

        $bridge->changeFieldFormOptions(
            type: 'users',
            fieldName: 'mobile_phone',
            displayed: true,
            group: 'group_contact'
        );
    }
}
