<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class UpdateSpacesToolsAndDeleteContracts extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeDeleteField('node', 'job_offers', 'contracts');
        $this->getBridge()?->contentTypeDelete('contracts');

        $this->getBridge()?->contentTypeDeleteField('node', 'spaces', 'tools');
        $this->getBridge()?->contentTypeCreateOrUpdateField('spaces', 'tools_categories', [
            'name' => 'tools_categories',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 6,
            'title' => [
                'fr' => 'Catégorie d\'outil',
            ],
            'description' => [
                'fr' => 'Choix de la catégorie d\'outils qui doivent remonter',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 6,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['tools_categories'],
                'cardinality' => 1,
            ],
        ]);
        $this->finishUp();
    }
}
