<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddSpacesFoldersParentField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField('spaces_folders', 'spaces_folders', [
            'name' => 'spaces_folders',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'classifiable' => 'spaces',
            'title' => [
                'fr' => 'Dossier parent',
            ],
            'description' => [
                'fr' => 'Si le dossier n\'a pas de dossier parent, il remonte à la racine de l\'espace',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['spaces_folders'],
                'cardinality' => 1,
            ],
        ]);
        $this->finishUp();
    }
}
