<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

class DeleteUselessContentTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $bridgeContent = new BridgeContent();
        $contentTypes = ['folders', 'documents', 'dms_link'];

        foreach ($contentTypes as $contentType) {
            type_to_class($contentType)::all()->pluck('uuid')->each(fn (string $uuid) => $bridgeContent->contentDelete($contentType, $uuid));
            $this->getBridge()?->contentTypeDelete($contentType);
        }

        $this->finishUp();
    }
}
