<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

class UpdateUsersEditableFields extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $usersEditableFields = [
            'function',
            'activity',
            'link_teams',
        ];

        foreach ($usersEditableFields as $field) {
            $this->getBridge()?->updateFieldOptions('users', $field, [
                'editable' => true,
            ]);
        }

        $this->finishUp();
    }
}
