<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'spaces_files',
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Fichier d\'espace',
        ],
    ],
    'fields' => [
        [
            'name' => 'file',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Fichier',
            ],
            'widget' => [
                'type' => BridgeContentType::FILE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::FILE_FIELD,
            'settings' => [
                'display_field' => false,
                'display_default' => false,
                'uri_scheme' => 'public',
                'target_type' => 'file',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'spaces_folders',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Dossier lié',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['spaces_folders'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Ordre d\'affichage',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
    ],
];
