<?php

use Adldap\Models\Entry;
use Inside\Host\Bridge\BridgeContent;

if (!function_exists('get_ldap_reference')) {
    function get_ldap_reference(Entry $user, BridgeContent $bridge, string $attribute, string $contentType): ?array
    {
        if (!$user->hasAttribute($attribute)) {
            return null;
        }
        $uuids = [];
        $titles = $user->getAttribute($attribute);

        foreach ($titles as $title) {
            $entity = call_user_func(type_to_class($contentType).'::query')
                ->where('title', $title)
                ->first();

            if ($entity) {
                $uuid = $entity->uuid;
            } else {
                $uuid = $bridge->contentInsert(
                    $contentType,
                    [
                        'type' => 'node',
                        'bundle' => $contentType,
                        'title' => $title,
                        'uid' => 1,
                    ]
                );
            }

            $uuids[] = $uuid;
        }

        return empty($uuids) ? null : $uuids;
    }
}

return [
    'usernames' => [
        'ldap' => [
            'discover' => env('ADLDAP_LDAP_DISCOVER', 'samaccountname'),
            'authenticate' => env('ADLDAP_LDAP_AUTHENTICATE', 'userprincipalname'),
        ],
        'eloquent' => env('ADLDAP_ELOQUENT_VALUE', 'name'),
    ],
    'discovering_attributes' => 'name',
    'sync_attributes' => [
        'email' => 'userprincipalname',
        'name' => 'samaccountname',
        'firstname' => 'givenname',
        'lastname' => 'sn',
        'fullname' => 'displayname',
        'function' => 'title',
        'phone' => 'telephonenumber',
        'mobile_phone' => 'mobile',
        'internal_phone' => 'othertelephone',
        'is_maintenance' => 'maintenance',
        'services' => function (Entry $user, BridgeContent $bridge) {
            return get_ldap_reference($user, $bridge, 'services', 'services');
        },
    ]
];
