<?php

use Inside\Content\Models\Contents\Comments;
use Inside\Content\Models\Contents\News;
use Inside\Content\Models\Contents\Users;
use Inside\Reaction\Models\Reaction;

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => 'newsletter_',
    ],
    'logo' => [
        'showLogo' => true,
        'logoUrl' => 'vendor/maecia/nfh2-back/resources/assets/img/logo.png',
        'logoWidth' => 170,
    ],
    'banner' => [
        'backgroundImageUrl' => 'vendor/maecia/nfh2-back/resources/assets/img/newsletter/banner.jpg',
        'backgroundColor' => '#FFFFF',
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_intro',
    ],
    'sections' => [
        'news_featured' => [
            'sectionType' => 'news',
            'types' => ['news_featured' => 'news'],
            'sorts' => ['published_at:desc'],
            'showCategoryTitle' => true,
            'categoryFieldName' => 'news_categories',
            'defaultCategoryColor' => '#1DAC83',
            'defaultImageUrl' => 'vendor/maecia/nfh2-back/resources/assets/newsletter/img/news-default.png',
            'link' => [
                'sectionLinkUrl' => 'actualites',
                'sectionTextColor' => '#1DAC83',
                'sectionLinkStrKey' => 'newsletter.see_all_news',
            ],
            'fieldLabel' => [
                'newsletter_news_featured' => [
                    'fr' => 'Actualités à la une',
                ],
            ],
        ],
        'news_regional' => [
            'sectionType' => 'news',
            'types' => ['news_regional' => 'news'],
            'sorts' => ['published_at:desc'],
            'showCategoryTitle' => true,
            'categoryFieldName' => 'news_categories',
            'defaultCategoryColor' => '#1DAC83',
            'defaultImageUrl' => 'vendor/maecia/nfh2-back/resources/assets/newsletter/img/news-default.png',
            'link' => [
                'sectionLinkUrl' => 'actualites',
                'sectionTextColor' => '#1DAC83',
                'sectionLinkStrKey' => 'newsletter.see_all_news',
            ],
            'fieldLabel' => [
                'newsletter_news_regional' => [
                    'fr' => 'Actualités régionales',
                ],
            ],
        ],
        'news_financial' => [
            'sectionType' => 'news',
            'types' => ['news_financial' => 'news'],
            'sorts' => ['published_at:desc'],
            'showCategoryTitle' => true,
            'categoryFieldName' => 'news_categories',
            'defaultCategoryColor' => '#1DAC83',
            'defaultImageUrl' => 'vendor/maecia/nfh2-back/resources/assets/newsletter/img/news-default.png',
            'link' => [
                'sectionLinkUrl' => 'actualites',
                'sectionTextColor' => '#1DAC83',
                'sectionLinkStrKey' => 'newsletter.see_all_news',
            ],
            'fieldLabel' => [
                'newsletter_news_financial' => [
                    'fr' => 'Affaires financières',
                ],
            ],
        ],
        'news_amg' => [
            'sectionType' => 'news',
            'types' => ['news_amg' => 'news'],
            'sorts' => ['published_at:desc'],
            'showCategoryTitle' => true,
            'categoryFieldName' => 'news_categories',
            'defaultCategoryColor' => '#1DAC83',
            'defaultImageUrl' => 'vendor/maecia/nfh2-back/resources/assets/newsletter/img/news-default.png',
            'link' => [
                'sectionLinkUrl' => 'actualites',
                'sectionTextColor' => '#1DAC83',
                'sectionLinkStrKey' => 'newsletter.see_all_news',
            ],
            'fieldLabel' => [
                'newsletter_news_amg' => [
                    'fr' => 'AMG (Achats Moyens Généraux)',
                ],
            ],
        ],
        'news_com' => [
            'sectionType' => 'news',
            'types' => ['news_com' => 'news'],
            'sorts' => ['published_at:desc'],
            'showCategoryTitle' => true,
            'categoryFieldName' => 'news_categories',
            'defaultCategoryColor' => '#1DAC83',
            'defaultImageUrl' => 'vendor/maecia/nfh2-back/resources/assets/newsletter/img/news-default.png',
            'link' => [
                'sectionLinkUrl' => 'actualites',
                'sectionTextColor' => '#1DAC83',
                'sectionLinkStrKey' => 'newsletter.see_all_news',
            ],
            'fieldLabel' => [
                'newsletter_news_com' => [
                    'fr' => 'Communication',
                ],
            ],
        ],
        'news_internal' => [
            'sectionType' => 'news',
            'types' => ['news_internal' => 'news'],
            'sorts' => ['published_at:desc'],
            'showCategoryTitle' => true,
            'categoryFieldName' => 'news_categories',
            'defaultCategoryColor' => '#1DAC83',
            'defaultImageUrl' => 'vendor/maecia/nfh2-back/resources/assets/newsletter/img/news-default.png',
            'link' => [
                'sectionLinkUrl' => 'actualites',
                'sectionTextColor' => '#1DAC83',
                'sectionLinkStrKey' => 'newsletter.see_all_news',
            ],
            'fieldLabel' => [
                'newsletter_news_internal' => [
                    'fr' => 'Contrôle interne',
                ],
            ],
        ],
        'news_dfc' => [
            'sectionType' => 'news',
            'types' => ['news_dfc' => 'news'],
            'sorts' => ['published_at:desc'],
            'showCategoryTitle' => true,
            'categoryFieldName' => 'news_categories',
            'defaultCategoryColor' => '#1DAC83',
            'defaultImageUrl' => 'vendor/maecia/nfh2-back/resources/assets/newsletter/img/news-default.png',
            'link' => [
                'sectionLinkUrl' => 'actualites',
                'sectionTextColor' => '#1DAC83',
                'sectionLinkStrKey' => 'newsletter.see_all_news',
            ],
            'fieldLabel' => [
                'newsletter_news_dfc' => [
                    'fr' => "DFC",
                ],
            ],
        ],
        'news_gm' => [
            'sectionType' => 'news',
            'types' => ['news_gm' => 'news'],
            'sorts' => ['published_at:desc'],
            'showCategoryTitle' => true,
            'categoryFieldName' => 'news_categories',
            'defaultCategoryColor' => '#1DAC83',
            'defaultImageUrl' => 'vendor/maecia/nfh2-back/resources/assets/newsletter/img/news-default.png',
            'link' => [
                'sectionLinkUrl' => 'actualites',
                'sectionTextColor' => '#1DAC83',
                'sectionLinkStrKey' => 'newsletter.see_all_news',
            ],
            'fieldLabel' => [
                'newsletter_news_gm' => [
                    'fr' => 'Direction générale',
                ],
            ],
        ],
        'news_grh' => [
            'sectionType' => 'news',
            'types' => ['news_grh' => 'news'],
            'sorts' => ['published_at:desc'],
            'showCategoryTitle' => true,
            'categoryFieldName' => 'news_categories',
            'defaultCategoryColor' => '#1DAC83',
            'defaultImageUrl' => 'vendor/maecia/nfh2-back/resources/assets/newsletter/img/news-default.png',
            'link' => [
                'sectionLinkUrl' => 'actualites',
                'sectionTextColor' => '#1DAC83',
                'sectionLinkStrKey' => 'newsletter.see_all_news',
            ],
            'fieldLabel' => [
                'newsletter_news_grh' => [
                    'fr' => 'GRH',
                ],
            ],
        ],
        'news_si' => [
            'sectionType' => 'news',
            'types' => ['news_si' => 'news'],
            'sorts' => ['published_at:desc'],
            'showCategoryTitle' => true,
            'categoryFieldName' => 'news_categories',
            'defaultCategoryColor' => '#1DAC83',
            'defaultImageUrl' => 'vendor/maecia/nfh2-back/resources/assets/newsletter/img/news-default.png',
            'link' => [
                'sectionLinkUrl' => 'actualites',
                'sectionTextColor' => '#1DAC83',
                'sectionLinkStrKey' => 'newsletter.see_all_news',
            ],
            'fieldLabel' => [
                'newsletter_news_si' => [
                    'fr' => "SI (Systèmes d’informations)",
                ],
            ],
        ],
        'job_offers' => [
            'types' => ['job_offers'],
            'sorts' => ['date:desc'],
            'categoryFieldName' => 'contracts',
            'defaultCategoryColor' => '#727272',
            'link' => [
                'sectionLinkUrl' => 'offres-emploi',
                'sectionTextColor' => '#1DAC83',
            ],
            'fieldLabel' => [
                'newsletter_job_offers' => [
                    'fr' => "Vacances de poste",
                ],
            ],
        ],
    ],
    'socials' => [
        'backgroundColor' => '#1DAC83',
        'links' => [
            'facebook' => [
                'url' => 'https://www.facebook.com/ANFH-106242578475203',
            ],
            'twitter' => [
                'url' => 'https://twitter.com/ANFH_',
            ],
            'linkedin' => [
                'url' => 'https://www.linkedin.com/company/anfh',
            ]
        ],
    ],
];
