<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

final class RemoveGroupsFromUser extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();
        $bridgeContentType->contentTypeDeleteField(
            entityType: 'user',
            type: 'user',
            fieldName: 'groups'
        );
        $bridgeContentType->changeFieldFormOptions(
            type: 'users',
            fieldName: 'birthday',
            displayed: true,
            group: 'group_infos'
        );
        Artisan::call('models:rebuild');
    }
}
