<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\Popins;

class MigrateToConnexionPopupsType extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridge = new BridgeContent();

        Popins::all()->each(function (Popins $popins) use ($bridge) {
            $attributes = $popins->getAttributes();
            $data = [
                'title' => $attributes['title'],
                'status' => $attributes['status'],
                'created_at' => $attributes['created_at'],
                'updated_at' => $attributes['updated_at'],
                'published_at' => $attributes['published_at'],
            ];

            $content = collect(get_content_sections($popins))->map(
                fn ($section) => collect($section)
                ->except(['uuid', 'uuid_host'])
                ->put('pgID', '_fresh')
                ->toArray()
            )->toArray();

            $uuid = $bridge->contentInsert('connexion_popups', $data, true, true);
            $bridge->contentUpdate('connexion_popups', ['uuid' => $uuid, 'content' => $content], true);
        });

        $bridgeContentType = new BridgeContentType();
        $bridgeContentType->contentTypeDelete('popins');
    }
}
